#!%PATH%\Common\Perl\bin\perl.exe

BEGIN {
    $0 = __FILE__;
    delete $INC{'FindBin.pm'};
}

my $DataLevel = 2004083101; # level of initialdata

our $RT;
use strict;
use constant IsWin32 => ($^O eq 'MSWin32');

use Config;
use FindBin;
use lib "$FindBin::Bin/../../../Common/perl/lib";
use lib "$FindBin::Bin/../../../Common/perl/site/lib";
use lib "$FindBin::Bin/../../win32/lib";
use lib "$FindBin::Bin/../../rt/local/lib";
use if +IsWin32, WinRT => qw/$DB $RT/;

$|++;

my $initdb;
my $DatabaseName = 'rt3';
my $Reg;

    require Win32::TieRegistry;
    $Reg = $Win32::TieRegistry::Registry->{
	"HKEY_LOCAL_MACHINE\\Software\\SecureScout\\Request Tracker"
    };
    $DatabaseName = $Reg->{DatabaseName} ||= "rt3";
    $initdb = WinRT->ReadFrom($WinRT::RT->sbin('rt-setup-database.in'));
    $initdb =~ s/\@\w+\@/$WinRT::RT->lib/eg;
    my $rt = WinRT->ReadFrom($WinRT::RT->lib('RT.pm.in'));
    $rt =~ s{\@\w+\@}{$FindBin::Bin/../../winrt/conf}g;
    eval $rt;
    $INC{'RT.pm'} = __FILE__;
    if ($Reg->{OIN104}) {
	$RT::EtcPath = "$FindBin::Bin/../../104/etc";
    }
    else {
	$RT::EtcPath = "$FindBin::Bin/../../rt/etc";
    }
    $RT::LocalEtcPath = "$FindBin::Bin/../../rt/local/etc";


$initdb =~ s/<STDIN>/'y'/g;
$initdb =~ s/\bexit\b/die/g;
$initdb =~ s/die/warn/g;

use DBI;

my $do_it = 1;
my $first_time = 0;
my $dbh;
my $port = (($^O eq 'MSWin32') ? ';port=8285' : '');
my $user = (($^O eq 'MSWin32') ? 'root' : 'root');
my $dsn = "DBI:mysql:database=$DatabaseName;host=localhost$port";
my $approval_id = 2;

{
    $dbh = DBI->connect($dsn, $user, '', { PrintError => 0 });
    if ($dbh) {
	my ($ok) = $dbh->selectrow_array("SELECT Name FROM Attributes WHERE ObjectType='RT::DataLevel' and ObjectId=$DataLevel");
	$do_it = 0 unless $ENV{QUERY_STRING} =~ /do_?it/i or !$ok;

	if (!$ok) {
	    print "Registering data level $DataLevel...\n";
        }

	$dbh->do("SET NAMES 'utf8'");

	my $ary = eval { $dbh->selectall_arrayref('SHOW CREATE TABLE Links') };
	if ( eval { $ary->[0][1] =~ /ascii/i } ) {
	    print "Performing Links updates...\n";
	    $dbh->do(q(
		ALTER TABLE Links
	       	  MODIFY Base varchar(240) CHARACTER SET binary NULL,
		  MODIFY Target varchar(240) CHARACTER SET binary NULL;
	    )) or do { print "ERROR:\n".$dbh->errstr; exit };
	}

	$ary = eval { $dbh->selectall_arrayref('SHOW CREATE TABLE Sessions') };
	if ( eval { $ary->[0][1] =~ /longtext/i } ) {
	    print "Performing Sessions updates...\n";
	    $dbh->do(q(
		ALTER TABLE Sessions 
		  MODIFY a_session LONGBLOB;
	    )) or do { print "ERROR:\n".$dbh->errstr; exit };
	    $dbh->do(q(
		ALTER TABLE Attachments
	       	  MODIFY Content LONGBLOB,
	       	  MODIFY Headers LONGBLOB;
	    )) or do { print "ERROR:\n".$dbh->errstr; exit };
	}

	my $info = eval { $dbh->selectall_arrayref('DESCRIBE Users')->[5][1] };
	if ($info =~ /varchar\(40\)/i) {
	    print "Performing UTF-8 updates...\n";

	    local $/ = ';';
	    open( SCHEMA, "<", "$FindBin::Bin/../../104/etc/schema.mysql" ) or die $!;
	    while (<SCHEMA>) {
		s/.*(?=CREATE TABLE)//is;
		s/^CREATE TABLE (\w+) \(/ALTER TABLE $1/i or next;
		s/^[ \t]+(?!.*char\().*$//mig;
		s/^[ \t]+/MODIFY /mg;
		s/^\).*/\nDEFAULT CHARACTER SET utf8;/m or print $_;
		$dbh->do($_) or do { print "ERROR:\n$_\n".$dbh->errstr; exit };
	    }
	}
	print "Performing upgrade (you can safely ignore ACL, User and Queue errors)....\n";
	($approval_id) = $dbh->selectrow_array("select Id from Queues where Name = '___Approvals'");
	if (!$approval_id) {
	    print "SANITY CHECK FAILED!  YOU DO NOT HAVE A QUEUE NAMED '___Approvals'!  BAD USER!  NO COOKIE!\n\n\n";
	    exit;
	}
	$dbh->do("DELETE FROM Templates WHERE Name='DefaultApproval' AND CONTENT NOT LIKE '%===Create-Ticket:%'");
	# $dbh->do("UPDATE Queues SET Disabled = 1 WHERE Disabled > 1");
	$dbh->do("UPDATE Attributes SET Description = REPLACE(Description, '-', '/') WHERE ObjectType = 'RT::Group' AND (Name = 'Due' OR Name = 'Start') AND Description IS NOT NULL");
	$dbh->do("DELETE FROM Sessions WHERE DATE_SUB(NOW(), INTERVAL 30 DAY) > LastUpdated");

	@ARGV = ('--action=insert', "--datafile=$RT::EtcPath/initialdata");
	$initdb =~ s{require \$datafile}{(
	    require \$datafile and
	    \$RT::Handle->dbh->do('delete from ScripActions') and
	    \$RT::Handle->dbh->do('delete from ScripConditions') and
	    \$RT::Handle->dbh->do('delete from Scrips where Creator = 1 and (Queue = 0 or Queue = $approval_id);') and
	    \$RT::Handle->dbh->do('delete from Templates where Creator = 1 and (Queue = 0 or Queue = $approval_id);')
	)};
	# XXX: eventually update all scrips, not only defaultapprovals
	$initdb =~ s{if \(\@Groups\)}{if (0)};
	my $foo = << '.';
	    my ($act) = $RT::Handle->dbh->selectrow_array("select Id from ScripActions where Name = 'Create Tickets'");
	    my ($cnd) = $RT::Handle->dbh->selectrow_array("select Id from ScripConditions where Name = 'On Create'");
	    $RT::Handle->dbh->do("update Scrips set ScripAction = $act where Description = 'Default Approval'");
	    $RT::Handle->dbh->do("update Scrips set ScripCondition = $cnd where Description = 'Default Approval'");
	    use RT::Tickets; use RT::Ticket;
	    use RT::Links;   use RT::Link;
	    print("Refreshing approval tickets, please wait...\n</pre>");
	    my $tickets = RT::Tickets->new($RT::SystemUser);
	    $tickets->LimitType( VALUE => 'approval' );
	    while (my $ticket = $tickets->Next) {
		# next if $ticket->OriginTicket and $ticket->OriginQueue;
		my ($approving) = $ticket->AllDependedOnBy( Type => 'ticket' );
		next unless $approving and $approving->Id;
		print(". ");
		$ticket->SetOriginObj( $approving );
	    }
	    print("<pre>\n");
	    $RT::Handle->Disconnect();
.
	$initdb =~ s{\$RT::Handle->Disconnect\(\);}{$foo}g;
    }
    elsif (DBI->errstr =~ /^Unknown database 'rt3'/) {
	print "Performing first-time installation....\n";
	@ARGV = ('--action=init', "--datafile=$RT::EtcPath/initialdata");
	$first_time = 1;
    }
    else {
	print "Unknown DBI error (" . DBI->errstr . "), aborting!";
	exit;
    }
}

if ($do_it) {
    $initdb =~ s/\$RT::EtcPath/"$RT::EtcPath"/g;
    $initdb =~ s/\$RT::LocalEtcPath/"$RT::LocalEtcPath"/g;
    eval $initdb;
    if ($@) {
        print $@;
    }
    else {
        $dbh = DBI->connect($dsn, $user, '', { PrintError => 0 });
        $dbh->do("INSERT INTO Attributes (Name, ObjectType, ObjectId) VALUES (?, ?, ?)", {}, 'DataLevel', 'RT::DataLevel', $DataLevel);
    }
}

$RT::DatabaseType ||= 'mysql';
open( SCHEMA_LOCAL, "<" . $RT::LocalEtcPath . "/schema." . $RT::DatabaseType ) or die "Cannot find $RT::LocalEtcPath/schema.$RT::DatabaseType: $!";
my @schema;
my $statement = "";
foreach my $line (<SCHEMA_LOCAL>) {
    $line =~ s/\#.*//g;
    $line =~ s/--.*//g;
    $statement .= $line;
    if ( $line =~ /;(\s*)$/ ) {
	$statement =~ s/;(\s*)$//g;
	push @schema, $statement;
	$statement = "";
    }
}

foreach my $statement (@schema) {
    my $sth = $dbh->prepare($statement) or die $dbh->errstr;
    $sth->execute;
}

my $ary = eval {
    $dbh->selectall_arrayref("SELECT Description FROM Attributes WHERE Name = 'Company' AND ObjectType = 'RT::Queue' AND ObjectId = $approval_id;");
} || [];

if ($#$ary or $ary->[0][0] ne '0') {
    $dbh->do("DELETE FROM Attributes WHERE Name = 'Company' AND ObjectType = 'RT::Queue' AND ObjectId = $approval_id;");
    $dbh->do("INSERT INTO Attributes (Name, Description, ObjectType, ObjectId) VALUES (?, ?, ?, ?)", {}, 'Company', 0, 'RT::Queue', $approval_id);
}
