package RT::Queues;

use strict;
no warnings qw(redefine);

sub Categories {
    my $self = shift;
    return [ split(/\n/, $RT::SystemUser->Attribute($self->CategoriesKey)) ];
}

sub SetCategories {
    my ($self, $list) = @_;
    $RT::SystemUser->SetAttribute($self->CategoriesKey, join("\n", @$list));
}

sub CategoriesKey { 'Categories' }

sub LimitWatcher {
    my $self = shift;
    my %args = ( OPERATOR => '=',
		 VALUE => undef,
		 TYPE => undef,
		 FIELD => 'EmailAddress',
		@_);

    my $groups = $self->Join(
	TYPE   => 'left',
	ALIAS1 => 'main',
	FIELD1 => 'id',
	TABLE2 => 'Groups',
	FIELD2 => 'Instance'
    );
    my $members = $self->Join(
	TYPE   => 'left',
	ALIAS1 => $groups,
	FIELD1 => 'id',
	TABLE2 => 'CachedGroupMembers',
	FIELD2 => 'GroupId'
    );
    my $users = $self->Join(
	TYPE   => 'left',
	ALIAS1 => $members,
	FIELD1 => 'MemberId',
	TABLE2 => 'Users',
	FIELD2 => 'id'
    );
    $self->Limit(
	ALIAS      => $groups,
	FIELD      => 'Domain',
	OPERATOR   => '=',
	VALUE      => 'RT::Queue-Role',
    );
    $self->Limit(
	ALIAS      => $groups,
	FIELD      => 'Type',
	OPERATOR   => '=',
	VALUE      => $args{TYPE}
    ) if $args{TYPE};
    $self->Limit(
	ALIAS      => $users,
	FIELD      => $args{FIELD},
	OPERATOR   => $args{OPERATOR},
	VALUE      => $args{VALUE},
    );
}

1;
