use strict;
no warnings 'redefine';

sub _SetOwner {
    my ($self, %args) = @_;
    return if $self->TicketObj->OwnerObj->id == $RT::Nobody->id;

    my $OwnerObj = $self->TicketObj->OwnerObj;
    my @Addresses = $OwnerObj->EmailAddress;
    push @Addresses, (
       	$OwnerObj->DelegateAddresses(
	    Queue => $self->TicketObj->OriginQueue ||
	    $self->TicketObj->Queue
        )
    ) unless $args{OwnerOnly};

    # If we're not sending to Ccs or requestors, 
    # then the Owner can be the To.
    if ("@{$args{To}}") {
	push ( @{$args{Bcc}}, @Addresses );
    }
    else {
	push ( @{$args{To}}, @Addresses );
    }
}

sub _SetResolvedApprovers {
    my ($self, %args) = @_;

    my $links = $self->TicketObj->DependsOn;
    while (my $link = $links->Next) {
        my $obj = $link->TargetObj;
        if ($obj->Status eq 'resolved') {
            local $self->{TicketObj} = $obj;

	    # Owner and Creators for each transactions
	    $self->_SetOwner(%args, OwnerOnly => 1);
	    $self->_SetActors(%args);
        }
    }
}

sub _SetActors {
    my ($self, %args) = @_;

    my $transactions = $self->TicketObj->Transactions;
    while (my $txn = $transactions->Next) {
	my $mail = $txn->CreatorObj->EmailAddress or next;
	push ( @{$args{Cc}}, $mail );
    }
}

1;
