# $File: //depot/RT/104/lib/RT/CompanySpecific.pm $ $Author: autrijus $
# $Revision: #8 $ $Change: 8397 $ $DateTime: 2003/10/13 03:01:54 $

# Now redefine all CompanySpecific foobars we will ever need

package RT::CurrentUser;

sub Company {
    my $self = shift;
    return $self->{Company} ||= $self->UserObj->val('company');
}

package RT::Users;

sub _DoSearch {
    my $self = shift;
    $self->LimitToCompany if $RT::CompanySpecific;
    $self->LimitToEnabled unless $self->{'find_disabled_rows'};
    return ( $self->SUPER::_DoSearch(@_) );
}

package RT::Groups;

sub _DoSearch {
    my $self = shift;
    $self->LimitToCompany if $RT::CompanySpecific;
    return ( $self->SUPER::_DoSearch(@_) );
}

sub RoleMapKey {
    my $self = shift;
    my $key  = 'RoleMap';
    $key .= ($self->CurrentUser->Attribute('Company') || '') if $RT::CompanySpecific;
    return $key;
}

package RT::Queues;

sub _DoSearch {
    my $self = shift;
    $self->LimitToCompany if $RT::CompanySpecific;
    $self->LimitToEnabled unless $self->{'find_disabled_rows'};
    return ( $self->SUPER::_DoSearch(@_) );
}

sub CategoriesKey {
    my $self = shift;
    my $key  = 'Categories';
    $key .= ($self->CurrentUser->Attribute('Company') || '') if $RT::CompanySpecific;
    return $key;
}

package RT::Reports;

sub _DoSearch {
    my $self = shift;
    $self->LimitToCompany if $RT::CompanySpecific;
    $self->LimitToEnabled unless $self->{'find_disabled_rows'};
    return ( $self->SUPER::_DoSearch(@_) );
}

package RT::ReportSources;

sub _DoSearch {
    my $self = shift;
    $self->LimitToCompany if $RT::CompanySpecific;
    $self->LimitToEnabled unless $self->{'find_disabled_rows'};
    return ( $self->SUPER::_DoSearch(@_) );
}

package RT::User;

sub UpdateCompany {
    my $self = shift;
    $self->SetAttribute( Company => (shift || eval { $self->val('company') } || 0) );
}

package RT::Queue;

sub UpdateCompany {
    my $self = shift;
    my $company = shift;
    my $UserObj = $self->AdminCc->UserMembersObj->First || $self->CreatorObj;
    $self->SetAttribute(
	Company => $company || $UserObj->Attribute('Company') || $self->Attribute('Company') || 0
    );
}

package RT::Group;

sub UpdateCompany {
    my $self = shift;
    my $company = shift;

    if (!$company) {
	my $Members = $self->UserMembersObj;
	while (my $UserObj = $Members->Next) {
	    last if $company = $UserObj->Attribute('Company');
	}
    }

    $company ||= $self->CurrentUser->UserObj->Attribute('Company');

    $self->SetAttribute(
	Company => ($company || $self->Attribute('Company') || 0)
    );
}

package RT::Report;

sub UpdateCompany {
    my $self = shift;
    my $company = shift;
    my $UserObj = $self->OwnerObj || $self->CreatorObj;
    $self->SetAttribute(
	Company => $company || $UserObj->Attribute('Company') || $self->Attribute('Company') || 0
    );
}

sub SearchHookCompany {
    my ($self, $tables, $SB) = @_;
    return unless $RT::CompanySpecific;

    my $company = $self->Attribute('Company')
	|| $self->CurrentUser->UserObj->Attribute('Company') or return;

    while (my ($table, $alias) = each %$tables) {
	next unless $SB->HasField(
	    TABLE   => $table,
	    FIELD   => 'company_id'
	);
	# find out whether $table has 'company_id'
	$SB->Limit(
	    CASESENSITIVE   => 1,
	    VALUE	    => $company,
	    FIELD	    => 'company_id',
	    $alias ? ( ALIAS => $alias ) : ()
	);
    }
}

package RT::ReportSource;

sub UpdateCompany {
    my $self = shift;
    my $company = shift;
    my $UserObj = $self->CreatorObj;
    $self->SetAttribute(
	Company => $company || $UserObj->Attribute('Company') || $self->Attribute('Company') || 0
    );
}

package RT::SearchBuilder;

sub LimitToCompany {
    my ($self, $company) = @_;
    if ($company ||= $self->CurrentUser->UserObj->Attribute('Company')) {
	$self->LimitAttribute(
	    NAME    => 'Company',
	    VALUE   => $company,
	    EMPTY   => 1
	);
    }
}

1;
