use strict;
no warnings 'redefine';

sub _ClassAccessible_Old {
    {
     
        id =>
		{read => 1, type => 'int(11)', default => ''},
        Name => 
		{read => 1, write => 1, type => 'varchar(200)', default => ''},
        Description => 
		{read => 1, write => 1, type => 'varchar(255)', default => ''},
        CorrespondAddress => 
		{read => 1, write => 1, type => 'varchar(120)', default => ''},
        CommentAddress => 
		{read => 1, write => 1, type => 'varchar(120)', default => ''},
        InitialPriority => 
		{read => 1, write => 1, type => 'int(11)', default => '0'},
        FinalPriority => 
		{read => 1, write => 1, type => 'int(11)', default => '0'},
        DefaultDueIn => 
		{read => 1, write => 1, type => 'int(11)', default => '0'},
        Creator => 
		{read => 1, auto => 1, type => 'int(11)', default => '0'},
        Created => 
		{read => 1, auto => 1, type => 'datetime', default => ''},
        LastUpdatedBy => 
		{read => 1, auto => 1, type => 'int(11)', default => '0'},
        LastUpdated => 
		{read => 1, auto => 1, type => 'datetime', default => ''},
        Disabled => 
		{read => 1, write => 1, type => 'smallint(6)', default => '0'},
        OverrideGlobalACL => 
		{read => 1, write => 1, type => 'smallint(6)', default => '0'},

 }
}

# {{{ sub Tickets

=head2 Tickets

Returns an RT::Tickets object of all of this queue's tickets.

=cut

sub Tickets {
    my $self = shift;

    my $tickets = RT::Tickets->new( $self->CurrentUser );

    if ( $self->CurrentUserHasRight('ShowTicket') ) {
	# XXX - change ->Name to ->Id when ::Tickets gets fixed
        $tickets->LimitQueue( VALUE => $self->Name );
    }

    return ($tickets);
}

# }}}

sub NameToId {
    my ($self, $id) = @_;
    return $id unless $id =~ /\D/;
    my $QueueObj = RT::Queue->new($RT::SystemUser);
    $QueueObj->Load($id);
    return $QueueObj->Id;
}

sub HasAdminCc {
    my ($self, $user) = @_;
    return $self->AdminCc->HasMember(RT::Principal->IdToObj($user));
}

sub HasCc {
    my ($self, $user) = @_;
    return $self->Cc->HasMember(RT::Principal->IdToObj($user));
}

sub HasWatcher {
    my ($self, $user) = @_;
    return $self->HasAdminCc($user) || $self->HasCc($user);
}

1;
