# $File: //depot/RT/winrt/conf/RT_Config.pm $ $Author: autrijus $
# $Revision: #9 $ $Change: 10291 $ $DateTime: 2004/03/02 08:53:43 $

package RT;

if ($^O eq 'MSWin32') {
    $LogDir			= WinRT->logs;
    $EtcPath			= "$BasePath/etc";
    $VarPath			= "$BasePath/../var";
    $TempPath			= "$BasePath/../var/temp";
    $LocalPath			= "$BasePath/local";
    $MasonComponentRoot		= "$BasePath/html";
    $MasonDataDir		= "$VarPath/mason_data";
    $MasonSessionDir		= "$VarPath/session_data";
    $WebUser			= 'Administrators';
    $WebGroup			= 'Administrators';

    # Make our own temporary directory and unlink stale dirs in it
    require File::Glob;
    $TempPath =~ s!\\!/!g;
    mkdir $TempPath unless -d $TempPath;
    rmdir for File::Glob::bsd_glob("$TempPath/*");
    $TempPath =~ s!/!\\!g;
    $ENV{TMPDIR} = $ENV{TEMP} = $ENV{TMP} = $TempPath;

    # Use a more sensible temporary directory name
    no warnings 'redefine';
    require File::Temp;
    *File::Temp::_replace_XX = sub {
	my ($path, $ignore) = @_;
	if ($ignore) {
	    substr($path, 0, - $ignore) =~ s/X(?=X*\z)/int(rand(10))/ge;
	} else {
	    $path =~ s/X(?=X*\z)/int(rand(10))/ge;
	}
	$path =~ s/(\d+)$/msgid-$1.tmp/;
	return $path;
    };

    Set($DatabaseType,			'mysql'			);
    Set($DatabasePort,			8285			);
    Set($LogToSyslog,			''			);
    Set($LogToScreen,			''			);
    Set($LogToFile,			'debug'			);
    Set($LogToFileNamed,		'rt.log'		);
    Set($MailCommand,			'smtp'			);
    Set($UseFriendlyFromLine,		0			);
    Set($UseFriendlyToLine,		0			);
    Set($NotifyActor,			1			);
    Set($AlwaysUseBase64,		1			);

    require Win32::TieRegistry;
    my $Reg = $Win32::TieRegistry::Registry->{
	'HKEY_LOCAL_MACHINE\Software\SecureScout\Request Tracker'
    };
    $VERSION = $Reg->{Version};

    require Socket;
    Set($WebBaseURL, sprintf("http://%vd:%PORT%", Socket::inet_aton(Win32::NodeName())) );

    Set($OIN104,		$Reg->{OIN104}			||= 0			);
    Set($LogToFile,		$Reg->{LogToFile}		||= 'debug'		);
    Set($LogToFileNamed,	$Reg->{LogToFileNamed}		||= "$LogDir/rt.log"	);
    Set($SMTPServer,		$Reg->{SMTPServer}		||= 'localhost'		);
    Set($SMTPFrom,		$Reg->{SMTPFrom}		||= 'rt@localhost'	);
    Set($SMTPDebug,		$Reg->{SMTPDebug}		||= 0			);
    Set($ExternalURL,		$Reg->{ExternalURL}		||= $WebBaseURL		);
    Set($rtname,		$Reg->{rtname}			||= Win32::NodeName()	);
    Set($Organization,		$Reg->{Organization}		||= Win32::NodeName()	);
    Set($ChangeOwnerUI,		$Reg->{ChangeOwnerUI}		||= 0			);
    Set($AdminAddress,		$Reg->{AdminAddress}		||= 'admin@localhost'	);
    Set($CompanySpecific,	$Reg->{CompanySpecific}		||= 0			);
    Set($DatabaseName,		$Reg->{DatabaseName}		||= 'rt3'		);
    Set($DatabaseBindRemote,	$Reg->{DatabaseBindRemote}	||= 0			);
    Set($RejectOverdueApprovals,$Reg->{RejectOverdueApprovals}	||= 0			);
    Set($ExternalDatabaseDSN,	$Reg->{ExternalDatabaseDSN}	||= 'dbi:ODBC:dsn=rt'	);
    Set($ExternalDatabaseUser,	$Reg->{ExternalDatabaseUser}	||= ''			);
    Set($ExternalDatabasePass,	$Reg->{ExternalDatabasePass}	||= ''			);
    Set($CorrespondAddress,	$SMTPFrom						);
    Set($CommentAddress,	$SMTPFrom						);

    if ($LogToFileNamed =~ m![\\/]!) {
	$LogToFileNamed =~ s!\\!/!g;
	$LogDir = $1 if $LogToFileNamed =~ s!(.*/)!!;
    }
}
else {
    $LogDir             = "$BasePath/../winrt/logs";
    $LogToFile          = 'debug';
    $LogToFileNamed     = 'rt.log';
    $LogToScreen        = 'debug';
    $WebBaseURL         = "";
    $CompanySpecific    = 0;
}

if ($OIN104) {
    $LocalPath = "$BasePath/../104";
    $SystemLanguage = 'zh-tw';
    @LexiconLanguages = qw(zh_tw zh_cn en);
}

$LocalLexiconPath		= "$LocalPath/po";
$MasonLocalComponentRoot	= "$LocalPath/html";

Set($DatabaseUser,		'root');
Set($DatabasePassword,		'');
Set($DatabaseDBA,	    	'root');
Set($ExternalDatabaseDSN,	'dbi:mysql:database=89390142;host=localhost');
Set($ExternalDatabaseUser,	'root');
Set($Timezone,			$ENV{TZ} || 'CST');
Set($UseCodeTickets,		1);
Set($NotifyActor,		1);
Set($UseFriendlyFromLine,	0);
Set($UseTransactionBatch,	1);

1;
