package WinRT::RT;

use strict;
our @ISA = 'WinRT';

sub new {
    my ($class, $base) = @_;
    my $self = $class->SUPER::NewObject($base, '../Request Tracker/rt', '/configure.ac');

    push @INC, $self->local('lib'), $self->lib;

    # require RT;
    $RT::BasePath = "$self->{path}/";
    $RT::CORE_CONFIG_FILE = $self->etc('RT_Config.pm');
    $RT::SITE_CONFIG_FILE = WinRT->conf('RT_Config.pm');

    return $self;
}

sub ParseMakefile {
    my $self = shift;
    my $mf = $self->ReadFrom("$self->{path}/configure.ac");

    my %vars;
    while ($mf =~ s/^\s*(\w+)\s*=\s*'(.*)'$//m) {
	my $x = $1;
	$x =~ s,!!PATH!!,C:/Program Files/SecureScout/Request Tracker/rt/,;
        $vars{$x} = $2;
    }
    
    return \%vars;
}

1;
