package WinRT::DB;

use strict;
our @ISA = 'WinRT';

sub new {
    my ($class, $base) = @_;

    $RT::DatabaseType ||= 'mysql'; # XXX

    my $self = $class->SUPER::NewObject($base, $RT::DatabaseType);
    $self->{daemon} = $self->bin('mysqld-nt.exe');
    $self->{admin} = $self->bin('mysqladmin.exe');

    return $self;
}

sub Launch {
    require Win32::Service;
    Win32::Service::StartService(Win32::NodeName() => 'OIN-MySQL');
}

sub Terminate {
    require Win32::Service;
    Win32::Service::StopService(Win32::NodeName() => 'OIN-MySQL');
}

sub _opened {
    use Socket qw/PF_INET SOCK_STREAM inet_aton sockaddr_in/;
    my $sock; socket($sock, PF_INET, SOCK_STREAM, getprotobyname('tcp'));

    my $opened = (connect($sock, sockaddr_in(
        $RT::DatabasePort || 8285,
        inet_aton($RT::DatabaseHost || 'localhost')
    )) and close($sock));
}

sub DESTROY {
    my $self = shift;
    # $self->Terminate if $self->{obj} and !$ENV{MOD_PERL};
}

1;
