no warnings 'redefine';

$_BriefDescriptions{CustomField} = sub {
    my $self = shift;
    my $field = $self->loc('CustomField');
    my ($old_value, $new_value) = ($self->OldValue, $self->NewValue);

    if ( $self->Field ) {
	my $cf = RT::CustomField->new( $self->CurrentUser );
	if (my $Requestor = $self->TicketObj->FirstRequestor->Id) {
	    my $RequestorObj = RT::CurrentUser->new;
	    $RequestorObj->Load($Requestor);
	    $cf->CurrentUser($RequestorObj);
	}
	$cf->Load( $self->Field );
	return '' if $cf->Attribute('OnCreate') eq 'hidden'
		 and $cf->Attribute('OnUpdate') eq 'hidden';
	$field = $cf->DescriptionOrName;
	$old_value = $cf->DescriptionForValue($old_value);
	$new_value = $cf->DescriptionForValue($new_value);
    }

    if ( $old_value eq '' ) {
	# no descriptions for apaprently empty CF transactions
	return '' unless length($field) and length($new_value);
	return ( $self->loc("[_1] [_2] added", $field, $new_value) );
    }
    elsif ( $new_value eq '' ) {
	return ( $self->loc("[_1] [_2] deleted", $field, $old_value) );
    }
    else {
	return $self->loc("[_1] [_2] changed to [_3]", $field, $old_value, $new_value );
    }
};

1;
