no warnings 'redefine';

# {{{ sub LoadAction 

=head2 LoadAction HASH

  Takes a hash consisting of TicketObj and TransactionObj.  Loads an RT::Action:: module.

=cut

sub LoadAction  {
    my $self = shift;
    my %args = ( TransactionObj => undef,
		 TicketObj => undef,
		 @_ );

    $self->{'_TicketObj'} = $args{'TicketObj'};
    
    #TODO: Put this in an eval  
    $self->ExecModule =~ /^(\w+)$/;
    my $module = $1;
    my $type = "RT::Action::". $module;
 
    eval "require $type" || die "Require of $type failed.\n$@\n";
    
    $self->{'Action'}  = $type->new ( 'ScripActionObj' => $self, 
				      'TicketObj' => $args{'TicketObj'},
				      'ScripObj' => $args{'ScripObj'},
				      'TransactionObj' => $args{'TransactionObj'},
				      'TemplateObj' => $self->TemplateObj,
				      'Argument' => $self->Argument,
				    );
}
# }}}

# {{{ sub TemplateObj

=head2 TemplateObj

Return this action\'s template object

=cut

sub TemplateObj {
    my $self = shift;
    return undef unless $self->{Template};
    if (!$self->{'TemplateObj'})  {
	require RT::Template;
	$self->{'TemplateObj'} = RT::Template->new($self->CurrentUser);
	$self->{'TemplateObj'}->LoadById($self->{'Template'});

	if ($self->{'TemplateObj'}->__Value('Queue') == 0 and $self->{TemplateObj}->Name ne 'DefaultApproval') {
	    my $to = $self->{'_TicketObj'};
	    my $TemplateObj = RT::Template->new($self->CurrentUser);
	    my ($ok, $err) = $TemplateObj->LoadQueueTemplate(Queue => $to->Queue, Name => $self->{TemplateObj}->Name);
	    if ($ok) {
		# found the queue-specific template with the same name
		$self->{TemplateObj} = $TemplateObj;
	    }
	}
	
    }
    
    return ($self->{'TemplateObj'});
}
# }}}

1;
