package RT::Action::SystemNotify;
require RT::Action::LightWeightSendMail;

use strict;
use vars qw/@ISA/;
@ISA = qw(RT::Action::LightWeightSendMail);

# {{{ sub SetRecipients

=head2 SetRecipients

Sets the recipients of this meesage to Owner, Requestor, AdminCc, Cc or All. 
Explicitly B<does not> notify the creator of the transaction.

=cut

sub SetRecipients {
    my $self = shift;

    my $arg = $self->Argument;

    $arg =~ s/\bAll\b/Owner,Requestor,AdminCc,Cc/;

    my ( @To, @PseudoTo, @Cc, @Bcc );


    if ( $arg =~ /\bRequestor\b/ ) {
        push ( @To, $self->TicketObj->Requestors->MemberEmailAddresses  );
    }

    if ( $arg =~ /\bCc\b/ ) {
        #If we have a To, make the Ccs, Ccs, otherwise, promote them to To
        if (@To) {
            push ( @Cc, $self->TicketObj->Cc->MemberEmailAddresses );
            push ( @Cc, $self->TicketObj->QueueObj->Cc->MemberEmailAddresses  );
        }
        else {
            push ( @Cc, $self->TicketObj->Cc->MemberEmailAddresses  );
            push ( @To, $self->TicketObj->QueueObj->Cc->MemberEmailAddresses  );
        }
    }

    if ( ( $arg =~ /\bOwner\b/ )
        && ( $self->TicketObj->OwnerObj->id != $RT::Nobody->id ) )
    {
        # If we're not sending to Ccs or requestors, 
        # then the Owner can be the To.
        if (@To) {
            push ( @Bcc, $self->TicketObj->OwnerObj->EmailAddress );
        }
        else {
            push ( @To, $self->TicketObj->OwnerObj->EmailAddress );
        }

    }

    if ( $arg =~ /\bAdminCc\b/ ) {
        push ( @Bcc, $self->TicketObj->AdminCc->MemberEmailAddresses  );
        push ( @Bcc, $self->TicketObj->QueueObj->AdminCc->MemberEmailAddresses  );
    }

    if ($RT::UseFriendlyToLine) {
        unless (@To) {
            push (
		@PseudoTo,
		sprintf($RT::FriendlyToLineFormat, $arg, $self->TicketObj->id),
	    );
        }
    }

    #Strip the sender out of the To, Cc and AdminCc and set the 
    # recipients fields used to build the message by the superclass.

    $RT::Logger->debug("$self: To is ".join(",",@To));
    $RT::Logger->debug("$self: Cc is ".join(",",@Cc));
    $RT::Logger->debug("$self: Bcc is ".join(",",@Bcc));

    @{ $self->{'To'} }  = @To;
    @{ $self->{'Cc'} }  = @Cc;
    @{ $self->{'Bcc'} } = @Bcc;
    @{ $self->{'PseudoTo'} } = @PseudoTo;
    return (1);
}

# }}}

eval "require RT::Action::SystemNotify_Vendor";
die $@ if ($@ && $@ !~ qr{^Can't locate RT/Action/SystemNotify_Vendor.pm});
eval "require RT::Action::SystemNotify_Local";
die $@ if ($@ && $@ !~ qr{^Can't locate RT/Action/SystemNotify_Local.pm});

1;
