use strict;
no warnings qw(redefine);

sub Starts {
    my ($self) = @_;
    $self->Attribute('Starts');
}

sub SetStarts {
    my ($self, $value) = @_;
    $value =~ s{\W+}{/}g;
    $self->SetAttribute(Starts => $value);
}

sub StartsDate {
    my $self = shift;
    my $obj = $self->StartsObj;
    return '' if $obj->Unix <= 0;
    return $obj->AsDate;
}

sub StartsObj {
    my $self = shift;
    my $time = RT::Date->new( $self->CurrentUser );

    # -1 is RT::Date slang for never
    if ( my $starts = $self->Starts ) {
	$starts .= " 00:00:00" unless $starts =~ /:/;
        $time->Set( Format => 'sql', Value => $starts );
    }
    else {
        $time->Set( Format => 'unix', Value => -1 );
    }

    return $time;
}

sub Due {
    my ($self) = @_;
    $self->Attribute('Due');
}

sub SetDue {
    my ($self, $value) = @_;
    $value =~ s{\W+}{/}g;
    $self->SetAttribute(Due => $value);
}

sub DueDate {
    my $self = shift;
    my $obj = $self->DueObj;
    return '' if $obj->Unix <= 0;
    return $obj->AsDate;
}

sub DueObj {
    my $self = shift;
    my $time = RT::Date->new( $self->CurrentUser );

    # -1 is RT::Date slang for never
    if ( my $due = $self->Due ) {
	$due .= " 00:00:00" unless $due =~ /:/;
        $time->Set( Format => 'sql', Value => $due );
    }
    else {
        $time->Set( Format => 'unix', Value => -1 );
    }

    return $time;
}

sub IsActive {
    my $self = shift;
    my ($day, $mon, $year) = (localtime(time))[3, 4, 5];
    $mon++; $year += 1900;
    my $date = sprintf("%04s/%02s/%02s", $year, $mon, $day);

    my $starts = $self->Starts;
    return if $starts and $starts gt $date;

    my $due = $self->Due;
    return if $due and $due lt $date;

    return 1;
}

sub DisplayName {
    my $self = shift;
    return $self->Name;
}

1;
