/*
 * ip-win32.c
 *
 * Copyright (c) 2002 Dug Song <dugsong@monkey.org>
 *
 * $Id: ip-win32.c,v 1.3 2002/03/29 01:39:26 dugsong Exp $
 */

#include "config.h"

#include <ws2tcpip.h>

#include <errno.h>
#include <stdlib.h>

#include "dnet.h"

struct ip_handle {
	WSADATA			wsdata;
	SOCKET			fd;
	struct sockaddr_in	sin;
};

ip_t *
ip_open(void)
{
	BOOL on;
	ip_t *ip;

	if ((ip = calloc(1, sizeof(*ip))) == NULL)
		return (NULL);

	if (WSAStartup(MAKEWORD(2, 2), &ip->wsdata) != 0) {
		free(ip);
		return (NULL);
	}
	if ((ip->fd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) ==
	    INVALID_SOCKET)
		return (ip_close(ip));
	
	on = TRUE;
	if (setsockopt(ip->fd, IPPROTO_IP, IP_HDRINCL,
	    (const char *)&on, sizeof(on)) == SOCKET_ERROR) {
		SetLastError(ERROR_NETWORK_ACCESS_DENIED);
		return (ip_close(ip));
	}
	ip->sin.sin_family = AF_INET;
	ip->sin.sin_port = htons(666);
	
	return (ip);
}

size_t
ip_send(ip_t *ip, const void *buf, size_t len)
{
	struct ip_hdr *hdr = (struct ip_hdr *)buf;
	struct sockaddr_in	sin;
	
	ip->sin.sin_addr.s_addr = hdr->ip_src;
	
	/* YI:
	 * here is defect  has been fixed
	 * the previous version of code sent packets to itself
	 * */
	
	sin.sin_family = AF_INET;
	sin.sin_port = htons(777);
	sin.sin_addr.s_addr = hdr->ip_dst;

	if ((len = sendto(ip->fd, (const char *)buf, len, 0,
	    (struct sockaddr *)&sin, sizeof(sin))) != SOCKET_ERROR)
		return (len);
	
	return (-1);
}

ip_t *
ip_close(ip_t *ip)
{
	WSACleanup();
	if (ip->fd != INVALID_SOCKET)
		closesocket(ip->fd);
	free(ip);
	return (NULL);
}
