#ifndef __REGISTRY_H__
#define __REGISTRY_H__

#include <windows.h>

class CRegKey
{
public:
	CRegKey(HKEY _hKey = 0) : hKey(_hKey)
	{}

	//CRegKey(HKEY hKeyParent, const TCHAR *strKey, DWORD dwAccess = KEY_ALL_ACCESS) : hKey(0)
	//{}
	
	~CRegKey()
	{ Close(); }

public:
	LONG Create(HKEY hKeyParent, const TCHAR *strKey, DWORD dwAccess = KEY_ALL_ACCESS)
	{
		Close();

		HKEY hKeyResult = 0;
		LONG result = ::RegCreateKeyEx(hKeyParent, strKey, 0, 0, REG_OPTION_NON_VOLATILE, dwAccess, 0, &hKeyResult, 0);

		if (result == ERROR_SUCCESS)
			hKey = hKeyResult;
		return result;
	}

	LONG Open(HKEY hKeyParent, const TCHAR *strKey, DWORD dwAccess = KEY_ALL_ACCESS)
	{
		Close();

		HKEY hKeyResult = 0;
		LONG result = ::RegOpenKeyEx(hKeyParent, strKey, 0, dwAccess, &hKeyResult);

		if (result == ERROR_SUCCESS)
			hKey = hKeyResult;
		return result;
	}

	bool SetMultyStringValue(const TCHAR *name, const TCHAR *value)
	{
		if (!hKey)
			return false;

		unsigned size = 0;
		const TCHAR *p = value;
		while(*p)
		{
			unsigned l;
			p += (l = _tcslen(p) + 1);
			size += l;
		}
		++size;

		return ::RegSetValueEx(hKey, name, 0, REG_MULTI_SZ, (const BYTE *)value, size * sizeof(TCHAR) ) == ERROR_SUCCESS;
	}

	bool SetStringValue(const TCHAR *name, const TCHAR *value)
	{
		if (!hKey)
			return false;

		return ::RegSetValueEx(hKey, name, 0, REG_SZ, (const BYTE *)value, _tcslen(value) * sizeof(TCHAR)) == ERROR_SUCCESS;
	}

	bool SetIntValue(const TCHAR *name, int value)
	{
		if (!hKey)
			return false;

		return ::RegSetValueEx(hKey, name, 0, REG_DWORD, (const BYTE *)&value, sizeof(value) ) == ERROR_SUCCESS;
	}

	const TCHAR *QueryStringValue(const TCHAR *name, TCHAR *buffer, unsigned long cb, const TCHAR *def)
	{ 
		if (!hKey)
			return 0;

		//DWORD dwType =  REG_SZ;
		LONG result = ::RegQueryValueEx(hKey, name, 0, 0, (BYTE *)buffer, &cb);
		if (result != ERROR_SUCCESS)
			return def;
		return buffer; 
	}

	const TCHAR *QueryMultyStringValue(const TCHAR *name, TCHAR *buffer, unsigned long cb, const TCHAR *def)
	{ 
		if (!hKey)
			return 0;

		LONG result = ::RegQueryValueEx(hKey, name, 0, 0, (BYTE *)buffer, &cb);
		if (result != ERROR_SUCCESS)
			return def;
		return buffer; 
	}


	int QueryIntValue(const TCHAR *name, int defaultValue )
	{
		if (!hKey)
			return false;

		int value;
		DWORD cb = sizeof(value);

		if ( ::RegQueryValueEx(hKey, name, 0, 0, (BYTE *)&value, &cb ) == ERROR_SUCCESS)
			return value;

		return  defaultValue;
	}

	void Close()
	{
		if (hKey)
			::RegCloseKey(hKey); 
		hKey = 0;
	}

	operator HKEY()
	{ return hKey; }


protected:
	HKEY hKey;
};

#endif //__REGISTRY_H__