
#include <windows.h>
#include <stdio.h>

#include "eventlog.h"

char *gszAppRegKey = "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\";


void EventLog::RegisterSource(const char *file_name, const char *service_name, unsigned int dwTypes)
{
	char szKey[256];
	strcpy(szKey, gszAppRegKey);
	strcat(szKey, service_name);
	HKEY hKey = 0;
	LONG lRet = ERROR_SUCCESS;


	// Create a key for that application and insert values for
	// "EventMessageFile" and "TypesSupported"
	if( RegCreateKey(HKEY_LOCAL_MACHINE, szKey, &hKey) == ERROR_SUCCESS ) 
	{
		lRet =	RegSetValueEx(
					hKey,						// handle of key to set value for
					"EventMessageFile",			// address of value to set
					0,							// reserved
					REG_EXPAND_SZ,				// flag for value type
					(const unsigned char *)file_name,		// address of value data
					strlen(file_name) + 1	// size of value data
				);

		// Set the supported types flags.
		lRet =	RegSetValueEx(
					hKey,					// handle of key to set value for
					"TypesSupported",		// address of value to set
					0,						// reserved
					REG_DWORD,				// flag for value type
					(const unsigned char *)&dwTypes,	// address of value data
					sizeof(unsigned int)			// size of value data
				);
		RegCloseKey(hKey);
	}


	// Add the service to the "Sources" value
	lRet =	RegOpenKeyEx( 
				HKEY_LOCAL_MACHINE,	// handle of open key 
				gszAppRegKey,		// address of name of subkey to open 
				0,					// reserved 
				KEY_ALL_ACCESS,		// security access mask 
				&hKey				// address of handle of open key 
			);

	if( lRet != ERROR_SUCCESS ) 
		return ;

    unsigned long dwSize;

    // retrieve the size of the needed value
	lRet =  RegQueryValueEx(
                hKey,           // handle of key to query 
                "Sources",      // address of name of value to query 
                0,              // reserved 
                0,              // address of buffer for value type 
                0,              // address of data buffer 
                &dwSize         // address of data buffer size 
            );

    if( lRet != ERROR_SUCCESS ) 
		return ;

	unsigned long  dwType;
	unsigned long dwNewSize	= dwSize + strlen( service_name ) + 1;
	char * Buffer = (char *)GlobalAlloc(GPTR, dwNewSize);

	lRet =	RegQueryValueEx(
				hKey,			// handle of key to	query 
				"Sources",// address of name of value	to query 
				0,				// reserved	
				&dwType,		// address of buffer for value type	
				(unsigned char *)Buffer,			// address of data buffer 
				&dwSize			// address of data buffer size 
			);
	if(	lRet !=	ERROR_SUCCESS )	
		return ;
	if (dwType	!= REG_MULTI_SZ)
		return ;


	// check whether this service is already a known source
	register char * p =	Buffer;
	for(; *p; p	+= strlen(p) + 1 ) 
	{
		if(	strcmp(p, service_name)	== 0 )
			break;
	}

	if(	! *p )	
	{
		// We're standing at the end of	the	stringarray
		// and the service does	still not exist	in the "Sources".
		// Now insert it at	this point.
		// Note	that we	have already enough	memory allocated
		// (see	GlobalAlloc() above). We also don't	need to	append
		// an additional '\0'. This	is done	in GlobalAlloc() above
		// too.
		strcpy(p, service_name);

		// OK -	now	store the modified value back into the
		// registry.
		lRet =	RegSetValueEx(
					hKey,			// handle of key to	set	value for
					"Sources",		// address of value	to set
					0,				// reserved
					dwType,			// flag	for	value type
					(unsigned char *)Buffer,			// address of value	data
					dwNewSize		// size	of value data
				);
	}


	GlobalFree( (HGLOBAL)Buffer );

    RegCloseKey(hKey);

}

void EventLog::DeregisterSource(const char *service_name)
{
	TCHAR szKey[256];
	strcpy(szKey, gszAppRegKey);
	strcat(szKey, service_name);

	HKEY hKey = 0;
	LONG lRet = ERROR_SUCCESS;

	lRet = RegDeleteKey(HKEY_LOCAL_MACHINE, szKey);

	// now we have to delete the application from the "Sources" value too.
	lRet =	RegOpenKeyEx( 
				HKEY_LOCAL_MACHINE,	// handle of open key 
				gszAppRegKey,		// address of name of subkey to open 
				0,					// reserved 
				KEY_ALL_ACCESS,		// security access mask 
				&hKey				// address of handle of open key 
			);
	if( lRet != ERROR_SUCCESS ) 
		return ;

	unsigned long dwSize;

	// retrieve the size of the needed value
	lRet =	RegQueryValueEx(
				hKey,			// handle of key to query 
				"Sources",		// address of name of value to query 
				0,				// reserved 
				0,				// address of buffer for value type 
				0,				// address of data buffer 
				&dwSize			// address of data buffer size 
			);

 	if( lRet != ERROR_SUCCESS ) 
		return ;

	
	unsigned long  dwType;
	char * Buffer = (char *)GlobalAlloc(GPTR, dwSize);
	char * NewBuffer = (char *)GlobalAlloc(GPTR, dwSize);

	lRet =	RegQueryValueEx(
				hKey,			// handle of key to query 
				"Sources",		// address of name of value to query 
				0,				// reserved 
				&dwType,		// address of buffer for value type 
				(unsigned char *)Buffer,			// address of data buffer 
				&dwSize			// address of data buffer size 
			);

	if( lRet != ERROR_SUCCESS ) 
		return ;

	if(dwType != REG_MULTI_SZ)
		return ;

	// check whether this service is already a known source
	register LPTSTR p = (LPTSTR)(Buffer);
	register LPTSTR pNew = (LPTSTR)(NewBuffer);

	int bNeedSave = FALSE;	// assume the value is already correct

	for(; *p; p += strlen(p) + 1) 
	{
		// except ourself: copy the source string into the destination
		if( strcmp(p, service_name) != 0 ) 
		{
			strcpy(pNew, p);
			pNew += strlen(pNew)+1;
		} 
		else 
		{
			bNeedSave = TRUE;		// *this* application found
			dwSize -= strlen(p)+1;	// new size of value
		}

	}
	if( bNeedSave ) {
		// OK - now store the modified value back into the
		// registry.
		lRet =	RegSetValueEx(
					hKey,			// handle of key to set value for
					"Sources",		// address of value to set
					0,				// reserved
					dwType,			// flag for value type
					(unsigned char *)NewBuffer,		// address of value data
					dwSize			// size of value data
				);
	}

	GlobalFree( (HGLOBAL)Buffer );
	GlobalFree( (HGLOBAL)NewBuffer );

	RegCloseKey(hKey);
}

