
#include "cmdline.h"


const CmdOption *CommandLine::Lookup(const TCHAR *option) const
{
	if (option == 0)
		return 0;

	for(int i = 0; options[i].name != NULL; ++i)
	{
		if ( _tcscmp(options[i].name, option) == 0)
			return &options[i];
	}
	return 0;
}


int CommandLine::Parse(int argc, TCHAR *argv[])
{

	for(int i = 1; i < argc; ++i)
	{
		CommandLineArgument a;
		if ( IsOptionName(argv[i]) )
		{
			const TCHAR *name = &(argv[i][1]);

			if (argv[i][0] == '-' && argv[i][1] == '-')
				++name;

			/* */
			const CmdOption *cmd = Lookup(name);
			if (!parseUndefined && cmd == 0)
				throw ExceptionUnknownOption(name);

			/* */
			if (cmd) 
			{
				if ( cmd->ArgumentMandatory() && (i + 1 >= argc || IsOptionName(argv[i+1])))
					throw ExceptionMandatoryArguemntMissing(name);
			}

			int parseArgument = 1;
			if (cmd && cmd->NoArgument()) 
				parseArgument = 0;

			if (parseArgument && i + 1 < argc && !IsOptionName( argv[i+1]))
				a = argv[ ++i ];

			if (cmd)
				name = cmd->Alias();

			namedArguments.Add(name, a);
		}
		else
		{
			unnamedArguments.Add( argv[i] );
		}
	}

	return namedArguments.size() + unnamedArguments.size();
}
