
#include <config.h>


#include "getopt.h"


#define BPF_MAJOR_VERSION
#include <pcap.h>


#include <err.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

/* XXX - libevent */
#undef timeout_pending
#undef timeout_initialized

#include <event.h>
#include <dnet.h>
#include <sys/tree.h>


#include "arpd.h"

static int			 arpd_sig;


void terminate_handler(int sig)
{
	extern int event_gotsig;

	event_gotsig = 1;
	arpd_sig = sig;
}


int signal_handler(void)
{
	syslog(LOG_INFO, "exiting on signal %d", arpd_sig);
	arpd_exit(0);
	/* NOTREACHED */
	return (-1);
}


static void usage(void)
{
	fprintf(stderr, "Usage: arpd [-d] [-W] [-i interface] [net]\n");
	exit(1);
}


void print_interfaces()
{
	pcap_if_t *alldevs, *d;
	char ebuf[10240];
	int i;

	if (pcap_findalldevs(&alldevs, ebuf) == -1)
		errx(1, "pcap_findalldevs: %s", ebuf);

	printf("\nInterface\tDevice\t\tDescription\n-------------------------------------------\n");
	for(i = 1, d=alldevs;d;d=d->next, i++) 
	{
		printf("%d %s",i, d->name);

		if (d->description)
			printf("\t%s",d->description);

		printf("\n");
	}
}



int main(int argc, char *argv[])
{
	struct event recv_ev;
	extern int (*event_sigcb)(void);
	char *dev;
	int c;
	FILE *fp;

	dev = NULL;
	debug = 0;
	
	while ((c = getopt(argc, argv, "dWi:h?")) != -1) {
		switch (c) {
		case 'd':
			debug = 1;
			break;
		case 'i':
			dev = optarg;
			break;
		case 'W':
			print_interfaces();
			exit(1);
			break;

		default:
			usage();
			break;
		}
	}
	argc -= optind;
	argv += optind;

	if (argc == 0)
		arpd_init(dev, 0, NULL);
	else
		arpd_init(dev, argc, argv);
	
	if ((fp = fopen(PIDFILE, "w")) == NULL)
		err(1, "fopen");

	fprintf(fp, "%d\n", GetCurrentThreadId());
	fclose(fp);
	
	chmod(PIDFILE, 0644);
	
	if (!debug) 
	{
		int options;
#ifdef LOG_PERROR
		options = LOG_PERROR|LOG_PID|LOG_CONS;
#else
		options = LOG_PID|LOG_CONS;
#endif

		openlog("arpd", options, LOG_DAEMON);

	}

	event_init();
	
	event_set(&recv_ev, pcap_fileno(arpd_pcap), EV_READ,
	    arpd_recv, &recv_ev);
	event_add(&recv_ev, NULL);
	
	/* Setup signal handler */
	if (signal(SIGINT, terminate_handler) == SIG_ERR) {
		perror("signal");
		return (-1);
	}
	if (signal(SIGTERM, terminate_handler) == SIG_ERR) {
		perror("signal");
		return (-1);
	}
	event_sigcb = signal_handler;
	
	event_dispatch();

	return (0);
}
