#ifndef __ARPD_H__
#define __ARPD_H__

#ifdef __cplusplus
extern "C"{
#endif 


struct arp_req 
{
	struct addr	 pa;
	int			 cnt;
	int			 negative;

	struct event active;
	struct event inactive;
	struct event discover;

	struct addr	 ha;

	SPLAY_ENTRY(arp_req)	next;
};


#define ARPD_MAX_ACTIVE		600
#define ARPD_MAX_INACTIVE	300


#define PIDFILE			"arpd.pid"

extern pcap_t *arpd_pcap;

extern int debug;

void arpd_init(char *dev, int naddresses, char **addresses);
void arpd_recv(int fd, short type, void *ev);
void arpd_exit(int status);
void arpd_set_respond_on_request_number( UINT max_attempts );
//int  arpd_get_respond_on_request_number();

#ifdef __cplusplus
}
#endif 


#endif //__ARPD_H__