
#ifndef __SCM_H__
#define __SCM_H__

#include <windows.h>
#include <tchar.h>



class ExceptionSCMOpenFailed 
{
public:
	ExceptionSCMOpenFailed(LONG _result) : result(_result)
	{}

public:
	LONG result;
};

class ExceptionSCMOpenServiceFailed 
{
public:
	ExceptionSCMOpenServiceFailed(LONG _result) : result(_result)
	{}

public:
	LONG result;
};

class ExceptionSCMQueryServiceFailed
{
public:
	ExceptionSCMQueryServiceFailed(LONG _result) : result(_result)
	{}

public:
	LONG result;
};

class ExceptionSCMControlServiceFailed
{
public:
	ExceptionSCMControlServiceFailed(LONG _result) : result(_result)
	{}

public:
	LONG result;
};



class ServiceHandle
{
public:
	ServiceHandle(SC_HANDLE h = 0) : sch(h)
	{}

	~ServiceHandle()
	{
		if (sch)
			::CloseServiceHandle(sch);
	}
	
	operator SC_HANDLE()
	{ return sch;}

	ServiceHandle& operator=(SC_HANDLE h) 
	{sch = h; return *this; }

protected:
	SC_HANDLE sch;
};

class SCM
{
public:
	static BOOL  UninstallService(LPCTSTR name);
	static BOOL  InstallService(LPCTSTR commandLine, LPCTSTR name, LPCTSTR displayName, DWORD dwStartType, LPCTSTR lpDependencies = 0, SC_HANDLE *pschService = 0);
	static BOOL  StopService(LPCTSTR name, long delay = 0, int (__stdcall *callback)(SC_HANDLE sch, SERVICE_STATUS *, long timeValue) = 0);
	static BOOL  StartService(LPCTSTR name, long delay = 0, int (__stdcall *callback)(SC_HANDLE sch, SERVICE_STATUS *, long timeValue) = 0);
	static DWORD QueryStatus(LPCTSTR name, SERVICE_STATUS *ss);

};


#endif //__SCM_H__