#ifndef __SERVICE_H__
#define __SERVICE_H__

#include <windows.h>

class ServiceStatus
{
public:
	ServiceStatus() : status_handle(0), check_point(0)
	{}

	~ServiceStatus()
	{}

	BOOL RegisterServiceCtrlHandler(LPCTSTR name, LPHANDLER_FUNCTION lpHandlerProc)
	{
		status_handle = ::RegisterServiceCtrlHandler(name, lpHandlerProc);
		return status_handle != 0;
	}

	BOOL SetServiceStatus(SERVICE_STATUS *pss)
	{
		return ::SetServiceStatus(status_handle, pss);
	}

	BOOL ReportStatus(DWORD currentState, DWORD Win32ExitCoce = 0, DWORD dwServiceExitCode = 0, DWORD dwControlsAccepted = SERVICE_ACCEPT_STOP|SERVICE_ACCEPT_SHUTDOWN)
	{
		SERVICE_STATUS s;

		check_point++;
		//
		s.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
		s.dwCurrentState  = currentState;
		s.dwControlsAccepted = dwControlsAccepted;
		s.dwWin32ExitCode = Win32ExitCoce;
		s.dwServiceSpecificExitCode = dwServiceExitCode;
		s.dwCheckPoint = check_point;
		s.dwWaitHint = 10000;
		
		return SetServiceStatus(&s);	
	}

protected:
	SERVICE_STATUS_HANDLE status_handle;
	unsigned check_point;

};

#endif //__SERVICE_H__