#ifndef __CMDLINE_H__
#define __CMDLINE_H__


#pragma warning(disable : 4786  )

#include <tchar.h>
#include <string>
#include <map>
#include <vector>

using namespace std;

#ifndef TSTRING_DEFINED
#define  TSTRING_DEFINED
typedef basic_string<TCHAR> _tstring;
#endif

class CommandLineArgument;
class ExceptionOptionNotFound;
class ExceptionIndexOutOfBounds;
class CommandLine;
class UnnamedArguments;
class NamedArguments;

typedef UnnamedArguments Arguments;

class ExceptionOptionNotFound
{
public:
	ExceptionOptionNotFound(const TCHAR *str) : option(str)
	{}
	const TCHAR *Name()
	{ return option.c_str(); }

protected:
	_tstring option; 
};

class ExceptionIndexOutOfBounds
{
};

class ExceptionUnknownOption
{
public:
	ExceptionUnknownOption(const TCHAR *name) : option(name)
	{}

	const TCHAR *Name()
	{ return option.c_str(); }

protected:
	_tstring option; 
};


class ExceptionMandatoryArguemntMissing
{
public:
	ExceptionMandatoryArguemntMissing(const TCHAR *name) : option(name)
	{}

	const TCHAR *Name()
	{ return option.c_str(); }

protected:
	_tstring option; 
};


#define argument_optional 0
#define argument_required 1
#define no_argument       2

class CmdOption
{
public:
	const TCHAR *Alias() const
	{ return (alias) ? alias : name; }
	
	int ArgumentMandatory() const
	{ return argument == argument_required; }

	int ArgumentOptional() const
	{ return argument == argument_optional; }

	int NoArgument() const
	{ return argument == no_argument; }
public:
	TCHAR *name;
	TCHAR *alias;
	int   argument;
};

class CommandLineArgument
{
public:
	CommandLineArgument()
	{}

	CommandLineArgument(const CommandLineArgument& a)
	{ Assign(a); }
	
	CommandLineArgument( const TCHAR * str ) : value(str)
	{}

	CommandLineArgument& operator=( const CommandLineArgument& a )
	{Assign(a); return *this; }

	CommandLineArgument& operator=( const TCHAR * str )
	{ value = str; return *this; }
	
	void Assign( const CommandLineArgument& a )
	{value = a.value; }

	const TCHAR *Value()
	{ return value.c_str(); }

	bool Empty()
	{ return value.c_str() == 0; }

	operator const TCHAR *()
	{ return value.c_str(); }

protected:
	_tstring value;
};


class UnnamedArguments : public vector<CommandLineArgument>
{
public:
	void Add(const CommandLineArgument& value )
	{ push_back(value); }

	void Add(const TCHAR *str )
	{ push_back(CommandLineArgument(str) ); }

	CommandLineArgument& Item(unsigned int n)
	{ 
		if (n >= size())
			throw ExceptionIndexOutOfBounds();
		return begin()[n];
	}

	unsigned int Count()
	{ return size(); }

	CommandLineArgument& operator[](unsigned int n)
	{ return Item(n); }
};

class NamedArguments : public  multimap<_tstring, CommandLineArgument>
{
public:
	void Add(const TCHAR *name, const CommandLineArgument& value )
	{ insert(value_type(name, value)); }

	bool Conains(const TCHAR *name)
	{ return find(name) != end(); }

	unsigned int Count(const TCHAR *name)
	{ return count(name); }

	unsigned int Enumerate( const TCHAR* name, Arguments& list)
	{
		int n = 0;
		pair<iterator, iterator> range = equal_range(name);
		for(iterator i = range.first; i != range.second; ++i, ++n)
		{
			list.push_back(i->second);
		}
		return n;

	}

	CommandLineArgument& Item(const TCHAR *name)
	{ 
		iterator i = find(name); 
		if (i == end()) 
			throw ExceptionOptionNotFound(name);
		return i->second;
	}

	CommandLineArgument& operator[](const TCHAR *name)
	{ return Item(name); }
};



class CommandLine 
{
public:
	CommandLine(const CmdOption *_options = 0, int _parseUndefined = 0) 
		: options(_options), parseUndefined(_parseUndefined)
	{}

	/* parses comand line arguments and initializes internal data 
	 * structures. 
	 * returns number of parsed arguments;
	 *
	 * this assumed the folliwing syntax
	 * {-|/|--}valueName [value] 
	 * */
	int Parse(int _argc, TCHAR *_argv[]);

	/* returns true if no arguments are specified into cmd line
	 * */
	bool Empty()
	{ return unnamedArguments.size() + namedArguments.size() == 0; }

	bool Conains( const TCHAR* option )
	{ return namedArguments.Conains(option); }

	unsigned int Enumerate( const TCHAR* option, Arguments& list)
	{ return namedArguments.Enumerate(option, list); }


	unsigned int Encountered(const TCHAR* option )
	{ return namedArguments.Count(option); }

	CommandLineArgument& Value(const TCHAR* option)
	{ return namedArguments[option]; }

	CommandLineArgument& operator[](const TCHAR* option)
	{ return namedArguments[option]; }

	Arguments& Unnamed()
	{ return unnamedArguments; }

public:

protected:

	static bool IsOptionName(const TCHAR *str)
	{ return str[0] == '-' || str[0] == '/'; }

	const CmdOption *Lookup(const TCHAR *option) const;

protected:
	UnnamedArguments unnamedArguments;
	NamedArguments namedArguments;

	const CmdOption *options;
	int parseUndefined;
};




#endif //__CMDLINE_H__