
#include "SCM.h"


BOOL SCM::InstallService(LPCTSTR commandLine, LPCTSTR name, LPCTSTR displayName, DWORD dwStartType, LPCTSTR lpDependencies, SC_HANDLE *pschService /*= 0*/ )
{
   /* Open current database on local machine 
    * */
	ServiceHandle schSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if (!schSCManager)
		throw ExceptionSCMOpenFailed( GetLastError() ) ;

	/* make entry point into servie database
	 * */
	ServiceHandle schService = CreateService( 
        schSCManager,               // SCManager database 
        name,						// name of service 
        displayName,				// service name to display 
        SERVICE_ALL_ACCESS,			// desired access 
        SERVICE_WIN32_OWN_PROCESS,  // service type 
        dwStartType,				// start type SERVICE_DEMAND_START
        SERVICE_ERROR_NORMAL,       // error control type 
        commandLine,						// service's binary 
        NULL,                       // no load ordering group 
        NULL,                       // no tag identifier 
        NULL,                       // no dependencies 
        NULL,                       // LocalSystem account 
        NULL);                      // no password 

	return schService != 0;
}

BOOL SCM::UninstallService(LPCTSTR name)
{
   /* Open current database on local machine 
    * */

	ServiceHandle schSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if (!schSCManager)
		throw ExceptionSCMOpenFailed( GetLastError() ) ;

	ServiceHandle schService = ::OpenService(schSCManager, name, DELETE);
	if (!schService)
		throw ExceptionSCMOpenServiceFailed( GetLastError() );

	BOOL ret =	DeleteService(schService);

	return ret;

}


BOOL SCM::StopService(LPCTSTR name, long delay /*= 0*/, int (__stdcall *callback)(SC_HANDLE sch, SERVICE_STATUS *, long timeValue) /*= 0*/)
{
    /* Open current database on local machine 
     * */
	ServiceHandle schSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_CONNECT);
	if (!schSCManager)
		throw ExceptionSCMOpenFailed( GetLastError() ) ;


	ServiceHandle schService = OpenService(schSCManager, name, SERVICE_QUERY_STATUS|SERVICE_STOP);
	if (!schService) 
		throw ExceptionSCMOpenServiceFailed( GetLastError() );


	/*
	 * Verify that service is not running
	 * */
	SERVICE_STATUS ss;
	if (! QueryServiceStatus(schService, &ss) )
		throw ExceptionSCMQueryServiceFailed( GetLastError() );

	if (ss.dwCurrentState == SERVICE_STOPPED)
		return TRUE;
	
	if (ss.dwCurrentState != SERVICE_RUNNING)
		return FALSE;

	if (!ControlService(schService, SERVICE_CONTROL_STOP, &ss ))
		throw ExceptionSCMControlServiceFailed( GetLastError() );


	if (delay == 0 || callback == 0)
		return TRUE;

	long timeOut = 0;
	while( 1 )
	{
		if ( !QueryServiceStatus(schService, &ss) )
			throw ExceptionSCMQueryServiceFailed( GetLastError() );

		BOOL bRet = (*callback)(schService, &ss, timeOut);
		if (!bRet || ss.dwCurrentState == SERVICE_STOPPED)
			break;


		Sleep(delay);
		timeOut += delay;
	}


	return ss.dwCurrentState == SERVICE_STOPPED;
}



BOOL SCM::StartService(LPCTSTR  name, long delay /*= 0*/, int (__stdcall *callback)(SC_HANDLE sch, SERVICE_STATUS *, long timeValue) /*= 0*/)
{
    /* Open current database on local machine 
     * */
	ServiceHandle schSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_CONNECT);
	if (!schSCManager)
		throw ExceptionSCMOpenFailed( GetLastError() ) ;


	ServiceHandle schService = OpenService(schSCManager, name, SERVICE_QUERY_STATUS|SERVICE_START);
	if (!schService) 
		throw ExceptionSCMOpenServiceFailed( GetLastError() );

	/*
	 * Verify that service is not running
	 * */
	SERVICE_STATUS ss;
	if (! QueryServiceStatus(schService, &ss) )
		throw ExceptionSCMQueryServiceFailed( GetLastError() );

	
	if (ss.dwCurrentState == SERVICE_RUNNING)
		return TRUE;

	if (ss.dwCurrentState != SERVICE_STOPPED)
		return FALSE;

	if (!::StartService(schService, 0, NULL))
		throw ExceptionSCMControlServiceFailed( GetLastError() );


	if (delay == 0 || callback == 0)
		return TRUE;

	long timeOut = 0;
	while( 1 )
	{
		if ( !QueryServiceStatus(schService, &ss) )
			throw ExceptionSCMQueryServiceFailed( GetLastError() );

		BOOL bRet = (*callback)(schService, &ss, timeOut);
		if (!bRet || ss.dwCurrentState == SERVICE_RUNNING)
			break;

		Sleep(delay);
		timeOut += delay;
	}


	return ss.dwCurrentState == SERVICE_RUNNING;
}


DWORD SCM::QueryStatus(LPCTSTR name, SERVICE_STATUS *ss)
{
    /* Open current database on local machine 
     * */
	ServiceHandle schSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_CONNECT);
	if (!schSCManager)
		throw ExceptionSCMOpenFailed( GetLastError() ) ;


	ServiceHandle schService = OpenService(schSCManager, name, SERVICE_QUERY_STATUS|SERVICE_START);
	if (!schService) 
		throw ExceptionSCMOpenServiceFailed( GetLastError() );

	/*
	 * Verify that service is not running
	 * */
	if (! QueryServiceStatus(schService, ss) )
		throw ExceptionSCMQueryServiceFailed( GetLastError() );

	
	return ss->dwCurrentState;
}

