#ifndef __ARPDCONFIG_H__
#define __ARPDCONFIG_H__

#pragma warning(disable : 4786  )

#include<windows.h>
#include<tchar.h>

#include<string>
#include<vector>
using namespace std;

#ifndef TSTRING_DEFINED
#define  TSTRING_DEFINED
typedef basic_string<TCHAR> _tstring;
#endif

class StringList  
{
public:
	StringList() : list(0), allocated(10), items(0), msz(0)
	{ 
		list = (TCHAR **)malloc(sizeof(TCHAR *) * allocated); 
		list[0] = 0;
	}

	~StringList()
	{ 
		Clear(); 
		free((void *)list);
	}

	void Add(const TCHAR *address)
	{
		if (items >= allocated)
			reallocate(allocated + 10);
		list[items++] = _tcsdup(address);
	}
		
	unsigned int Count()
	{ return items; }

	void Clear()
	{
		for(int i = 0; i < items; ++i)
			free((void *)list[i]);
		
		items = 0;
	}

	const TCHAR *Item(unsigned int n)
	{ 
		if (n >= Count())
			return 0; 
		return list[n];
	}

	const TCHAR *operator[](unsigned int n)
	{ return Item(n); }

	TCHAR **List()
	{ return list; }

	TCHAR *MultySZ()
	{
		if (msz)
			free((void *)msz);

		int i, s;
		for(s = i = 0; i < items; ++i)
		{
			s += _tcslen(list[i]) + 1;
		}
		++s;

		TCHAR *p = msz = (TCHAR *)malloc(s + sizeof(TCHAR));
		for(i = 0; i < items; ++i)
		{
			p += _tcslen(_tcscpy(p, list[i])) + 1;
			p[0] = 0;
		}

		return msz;
	}

	void ParseMSZ(const TCHAR *s)
	{
		if (!s)
			return;
		while(*s)
		{
			Add(s);
			s += _tcslen(s) + 1;
		}

	}

protected:
	void reallocate( unsigned int n )
	{
		list = (TCHAR **)realloc(list,  sizeof(TCHAR *) * n);
		allocated = n;
	}


protected:
	unsigned int allocated;
	unsigned int items;
	TCHAR **list;
	TCHAR *msz;
};


class ExceptionSaveConfig
{
};

class ExceptionLoadConfig
{
};


class ArpdConfig  
{
public:
	ArpdConfig() : maxRequestNumber(3)
	{}

	~ArpdConfig()
	{}

	static void Load(const TCHAR *registryKey, ArpdConfig& c );
	static void Save(const TCHAR *registryKey, ArpdConfig& c );

	StringList& Addresses()
	{ return al; }

	StringList& Devices()
	{ return devices; }

	_tstring& LogFile()
	{ return logFile; }

	LPCTSTR GetLogPath();
	
	UINT& MaxRequestNumber()
	{ return maxRequestNumber; }

protected:
	_tstring logFile;
	StringList al;
	StringList devices;
	UINT maxRequestNumber;

};



#endif //__ARPDCONFIG_H__