
#include "ArpdConfig.h"
#include "registry.h"



LPCTSTR ArpdConfig::GetLogPath()
{
	static TCHAR buffer[1024];

	if (! logFile.empty() )
	{
		if ( strrchr(logFile.c_str(), _T('\\')) != 0)
			return logFile.c_str();
	}

	::GetModuleFileName(NULL, buffer, sizeof(buffer));
	
	if ( strlen(buffer) + logFile.size() + 1 >= sizeof(buffer))
		return (logFile.size() ? logFile.c_str() : _T("arpd"));

	TCHAR *p = strrchr(buffer, _T('\\')) + 1;
	if (p == (TCHAR *)( sizeof(TCHAR) ))
		return _T("arpd");

	if (!logFile.c_str())
		strcpy(p, _T("arpd"));
	else
		strcpy(p, logFile.c_str());

	return buffer;
}


void ArpdConfig::Load(const TCHAR *registryKey, ArpdConfig& c )
{
	CRegKey k;
	if (k.Open(HKEY_LOCAL_MACHINE, registryKey, KEY_READ) != ERROR_SUCCESS)
		throw ExceptionLoadConfig();


	TCHAR buffer[10240];
	
	c.Addresses().ParseMSZ( k.QueryMultyStringValue(_T("addresses"), buffer, sizeof(buffer), _T("\0\0")));
	c.Devices().ParseMSZ( k.QueryMultyStringValue(_T("interface"), buffer, sizeof(buffer), _T("\0\0")));
	c.LogFile() = k.QueryStringValue( _T("logfile"), buffer, sizeof(buffer), 0);
	c.MaxRequestNumber() = k.QueryIntValue(_T("request-number"), c.MaxRequestNumber());


}

void ArpdConfig::Save(const TCHAR *registryKey,  ArpdConfig& c )
{
	CRegKey k;
	if (k.Create(HKEY_LOCAL_MACHINE, registryKey, KEY_WRITE|KEY_READ) != ERROR_SUCCESS)
		throw ExceptionSaveConfig();


	k.SetMultyStringValue( _T("interface"), c.Devices().MultySZ() );
	k.SetMultyStringValue( _T("addresses"), c.Addresses().MultySZ() );
	k.SetStringValue( _T("logfile"), c.LogFile().c_str() );
	k.SetIntValue(_T("request-number"), c.MaxRequestNumber() );

}
